# Green Tech Shredding - Lead Generation Wizard

A professional document shredding service lead generation application featuring an embeddable multi-step wizard for instant quotes and customer data collection.

## Features

- Multi-step wizard interface for collecting shredding service requirements
- Real-time quote calculation based on volume and service type
- Support for mobile shredding, off-site destruction, and drop-off services
- Automatic lead submission to PerfexCRM
- Email notifications for new leads
- Embeddable widget for third-party websites
- Mobile-responsive design with eco-friendly green theme

## Prerequisites

- Node.js 18 or higher
- npm or package manager

## Installation

1. **Clone or download the project**

2. **Install dependencies**
   ```bash
   npm install
   ```

3. **Configure environment variables** (Optional)
   
   Create a `.env` file in the root directory if you want to enable CRM and email integrations:
   
   ```env
   # PerfexCRM Integration (Optional)
   PERFEX_URL=https://your-perfex-instance.com
   PERFEX_API_TOKEN=your-api-token-here
   
   # Email Configuration (Optional)
   SMTP_HOST=smtp.gmail.com
   SMTP_PORT=587
   SMTP_USER=your-email@gmail.com
   SMTP_PASS=your-app-password
   EMAIL_FROM=your-email@gmail.com
   EMAIL_TO=cnngraphics@gmail.com
   ```

   **Note:** The application works without these configurations - leads will be stored in memory but won't be sent to CRM or email.

## Running the Application

**Development mode:**
```bash
npm run dev
```

The application will start on `http://localhost:5000`

**Production mode:**
```bash
npm run build
npm start
```

## Using the Lead Generation Wizard

1. Navigate to `http://localhost:5000` in your browser
2. Follow the 6-step wizard:
   - **Step 1: Material Types** - Select what needs to be shredded
   - **Step 2: Volume** - Enter quantity of boxes, cabinets, bags, or pallets
   - **Step 3: Service Type** - Choose mobile, off-site, or drop-off service
   - **Step 4: Location** - Enter ZIP code and timeline
   - **Step 5: Contact Info** - Provide contact details (lead submitted here)
   - **Step 6: Quote Display** - View instant quote and service details

## Embedding the Widget

You can embed this wizard on any website using one of two methods:

### Method 1: iframe Embed
```html
<iframe 
  src="https://your-domain.com/" 
  width="100%" 
  height="800" 
  frameborder="0"
  title="Get Shredding Quote">
</iframe>
```

### Method 2: JavaScript Embed
```html
<div id="shredding-widget"></div>
<script>
  (function() {
    var iframe = document.createElement('iframe');
    iframe.src = 'https://your-domain.com/';
    iframe.width = '100%';
    iframe.height = '800px';
    iframe.frameBorder = '0';
    iframe.title = 'Get Shredding Quote';
    document.getElementById('shredding-widget').appendChild(iframe);
  })();
</script>
```

## Quote Calculation Rules

### Volume Conversion (to standard boxes)
- File Boxes: 1 box = 1 standard box
- Filing Cabinets: 1 cabinet = 8 boxes
- Bags: 1 bag = 0.5 boxes
- Pallets: 1 pallet = 40 boxes

### Weight Calculation
- Each standard box = 30 pounds

### Pricing
**Mobile Shredding:**
- First 10 boxes or 1 bin or 200 lbs or less: $140 flat rate
- More than 10 boxes: $140 for first bin + $85 per additional bin or 200 lbs
- $45 for additional half bin (up to 5 boxes or 100 lbs)

**Off-Site Shredding:**
- 10 boxes or less: $55 flat rate
- More than 10 boxes: $35 + $4 per additional box

**Drop-Off Service:**
- $25.00 base fee + $35 per bin or up to 200 lbs

## Project Structure

```
green-tech-shredding/
├── client/               # Frontend React application
│   ├── src/
│   │   ├── components/   # React components
│   │   │   └── wizard/   # Multi-step wizard components
│   │   ├── hooks/        # Custom React hooks
│   │   ├── lib/          # Utilities and helpers
│   │   └── pages/        # Page components
│   └── index.html        # HTML entry point
├── server/               # Backend Express application
│   ├── routes.ts         # API routes and CRM integration
│   ├── storage.ts        # Data storage interface
│   └── index.ts          # Server entry point
├── shared/               # Shared types and schemas
│   └── schema.ts         # Database schema and types
└── package.json          # Dependencies and scripts
```

## Technology Stack

- **Frontend:** React, TypeScript, Tailwind CSS, shadcn/ui, Wouter
- **Backend:** Express.js, TypeScript
- **Data:** Drizzle ORM, PostgreSQL (optional)
- **Forms:** React Hook Form, Zod validation
- **State:** TanStack Query
- **Integrations:** PerfexCRM API, Nodemailer

## Customization

### Modifying Quote Calculations
Edit `client/src/lib/quote-calculator.ts` to adjust:
- Volume conversion rates
- Weight per box
- Service pricing tiers

### Styling
- Theme colors: Edit CSS variables in `client/src/index.css`
- Tailwind config: Modify `tailwind.config.ts`

### Adding Fields
1. Update types in `client/src/lib/types.ts`
2. Update schema in `shared/schema.ts`
3. Add fields to appropriate wizard step component
4. Update storage interface in `server/storage.ts`

## Support

For questions or issues, contact the development team.

## License

Proprietary - Green Tech Shredding
