import { FileText, Box, Truck, MapPin, User } from "lucide-react";

interface ProgressIndicatorProps {
  currentStep: number;
  totalSteps: number;
  steps: string[];
}

export function ProgressIndicator({ currentStep, totalSteps, steps }: ProgressIndicatorProps) {
  const progressPercentage = (currentStep / totalSteps) * 100;
  
  const stepIcons = [
    FileText, // Material
    Box,      // Volume
    Truck,    // Service
    MapPin,   // Location
    User,     // Contact
    FileText  // Quote (fallback)
  ];

  return (
    <div className="p-6 bg-green-50">
      <div className="flex items-center justify-between mb-4">
        <h2 className="text-lg font-semibold text-eco-secondary">Get Your Instant Quote</h2>
        <span className="text-sm text-gray-600">Step {currentStep} of {totalSteps}</span>
      </div>
      <div className="w-full bg-gray-200 rounded-full h-2 mb-4">
        <div 
          className="bg-eco-primary h-2 rounded-full transition-all duration-500" 
          style={{ width: `${progressPercentage}%` }}
        />
      </div>
      
      {/* Desktop Progress with Icons */}
      <div className="hidden md:flex justify-between items-center">
        {steps.map((step, index) => {
          const Icon = stepIcons[index] || FileText; // Fallback to FileText
          const isActive = index + 1 <= currentStep;
          const isCurrent = index + 1 === currentStep;
          
          return (
            <div key={step} className="flex flex-col items-center text-center flex-1">
              <div className={`w-10 h-10 rounded-full flex items-center justify-center mb-2 transition-colors ${
                isActive ? 'bg-eco-primary text-white' : 'bg-gray-200 text-gray-400'
              } ${isCurrent ? 'ring-2 ring-eco-primary ring-offset-2' : ''}`}>
                <Icon className="w-5 h-5" />
              </div>
              <span className={`text-xs font-medium ${
                isActive ? 'text-eco-primary' : 'text-gray-500'
              }`}>
                {step}
              </span>
            </div>
          );
        })}
      </div>
      
      {/* Mobile Progress - Simple Text */}
      <div className="flex md:hidden justify-between text-xs text-gray-500">
        {steps.map((step, index) => (
          <span 
            key={step} 
            className={index + 1 <= currentStep ? "text-eco-primary font-medium" : ""}
          >
            {step}
          </span>
        ))}
      </div>
    </div>
  );
}
