# Overview

Green Tech Shredding is a document destruction and shredding service application featuring an embeddable lead generation widget. The system helps customers get instant quotes for different shredding services and captures leads through a multi-step wizard interface. The application supports mobile shredding, off-site destruction, and drop-off services with real-time pricing calculations.

# User Preferences

Preferred communication style: Simple, everyday language.

# System Architecture

## Frontend Architecture
The client is built using React with TypeScript and follows a modern component-based architecture. The application uses Vite for development and build tooling, providing fast hot module replacement and optimized production builds.

**Key Design Decisions:**
- **React Router**: Uses Wouter for lightweight client-side routing
- **State Management**: Combines React hooks (useState) with TanStack Query for server state management
- **UI Framework**: Built with Radix UI primitives and shadcn/ui components for accessibility and consistency
- **Styling**: Tailwind CSS with custom CSS variables for theming, featuring an eco-friendly green color scheme
- **Form Handling**: React Hook Form with Zod validation for type-safe form management

**Component Structure:**
- Modular wizard components for the multi-step quote process
- Reusable UI components following atomic design principles
- Custom hooks for business logic separation (useWizard, useToast, useMobile)

## Backend Architecture
The server uses Express.js with TypeScript, following a REST API pattern. The architecture emphasizes simplicity and maintainability with clear separation of concerns.

**Key Design Decisions:**
- **Framework**: Express.js chosen for its simplicity and extensive ecosystem
- **TypeScript**: Full type safety across the entire codebase
- **Storage**: Flexible storage interface allowing easy switching between in-memory and database storage
- **Validation**: Zod schemas shared between client and server for consistent validation
- **Middleware**: Custom logging and error handling middleware

**API Structure:**
- Lead submission endpoint with comprehensive data capture
- Integration endpoints for external services (PerfexCRM, email)
- Widget embedding support for third-party websites

## Data Storage Solutions
The application uses a flexible storage pattern that currently supports in-memory storage but can easily be extended to use PostgreSQL through Drizzle ORM.

**Database Schema Design:**
- **Users Table**: Basic authentication support with username/password
- **Leads Table**: Comprehensive lead capture with JSON fields for complex data structures
- **Audit Trail**: CreatedAt timestamps and status tracking for lead management

**Storage Interface:**
- Abstract IStorage interface allows easy switching between storage implementations
- Current MemStorage implementation for development and testing
- PostgreSQL configuration ready via Drizzle ORM and Neon database

## Authentication and Authorization
Currently implements basic authentication structure with username/password storage. The system is designed to be easily extensible for more sophisticated authentication methods.

**Security Considerations:**
- Password storage ready (implementation depends on chosen hashing strategy)
- Session management prepared through storage interface
- HIPAA compliance features for document destruction industry requirements

## Business Logic Architecture
The quote calculation system implements sophisticated pricing logic for different service types with real-time calculations.

**Quote Calculation Engine:**
- Volume conversion system (different container types to standard boxes)
- Service-specific pricing models (mobile, off-site, drop-off)
- Dynamic pricing based on volume tiers and special requirements
- Real-time quote updates as users progress through the wizard

**Lead Management:**
- Multi-step data collection with progressive enhancement
- Comprehensive lead scoring and categorization
- Special requirements tracking (HIPAA, witnessed destruction, recurring services)

# External Dependencies

## Database and ORM
- **Drizzle ORM**: Type-safe database operations with PostgreSQL dialect
- **@neondatabase/serverless**: Serverless PostgreSQL database connection
- **connect-pg-simple**: PostgreSQL session store for authentication

## UI and Styling
- **Radix UI**: Accessible, unstyled UI primitives (@radix-ui/react-*)
- **shadcn/ui**: Pre-built components using Radix UI primitives
- **Tailwind CSS**: Utility-first CSS framework with custom theming
- **Lucide React**: Modern icon library with consistent styling

## Form and Validation
- **React Hook Form**: Performance-focused form library with minimal re-renders
- **@hookform/resolvers**: Validation resolvers for React Hook Form
- **Zod**: Runtime type validation and schema definition
- **drizzle-zod**: Integration between Drizzle schemas and Zod validation

## Data Fetching and State
- **TanStack Query**: Server state management with caching and synchronization
- **Wouter**: Lightweight routing library for single-page applications

## Development and Build Tools
- **Vite**: Fast build tool with HMR and optimized production builds
- **TypeScript**: Static type checking across the entire application
- **ESBuild**: Fast JavaScript/TypeScript bundler for server code

## Email and CRM Integration
- **Nodemailer**: Email sending functionality for notifications and confirmations
- **PerfexCRM Integration**: Custom integration for lead management and follow-up

## Utility Libraries
- **class-variance-authority**: Utility for creating variant-based component APIs
- **clsx**: Conditional CSS class name utility
- **date-fns**: Modern date manipulation library
- **nanoid**: Cryptographically secure ID generation

The application is designed to be easily deployable on platforms like Replit, with environment-based configuration for different deployment scenarios.